<?php
/* ==== File Desk (PHP 5.2+) ==== */
/* DEBUG:
ini_set('display_errors', 1); error_reporting(E_ALL);
*/
if(function_exists('mb_internal_encoding')){@mb_internal_encoding('UTF-8');}
session_start();
require dirname(__FILE__).'/config.php';
require dirname(__FILE__).'/functions/common.php';
require dirname(__FILE__).'/functions/auth.php';
require dirname(__FILE__).'/functions/fs.php';
$base = BASE_DIR !== '' ? safe_realpath(BASE_DIR) : getcwd();
if(!$base){ $base = getcwd(); }
if(!defined('BASE_PATH')) define('BASE_PATH',$base);
if(!isset($_SESSION['_flash'])) $_SESSION['_flash']=array('ok'=>array(),'err'=>array());
if(isset($_GET['a']) && $_GET['a']==='logout'){ do_logout(); header('Location: index.php'); exit; }
if(!logged_in()){
  if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['login'])){
    $u = isset($_POST['user'])?(string)$_POST['user']:'';
    $p = isset($_POST['pass'])?(string)$_POST['pass']:'';
    if(do_login($u,$p)){ header('Location: index.php'); exit; } else { $err='Username atau password salah.'; }
  }
  include dirname(__FILE__).'/inc/header.php';
  include dirname(__FILE__).'/inc/login.php';
  include dirname(__FILE__).'/inc/footer.php';
  exit;
}
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $p = isset($_POST['p'])?(string)$_POST['p']:BASE_PATH;
  $path = ensure_in_base(safe_realpath($p)); if(!$path)$path=BASE_PATH;
  try {
    $action = isset($_POST['a'])?(string)$_POST['a']:'';
    if($action==='save'){
      $file = isset($_POST['file'])?(string)$_POST['file']:'';
      $target = ensure_in_base(safe_realpath($file));
      if(!$target || !is_file($target)) throw new Exception('File tidak valid.');
      if(!is_writable($target)) throw new Exception('Tidak punya izin menulis file ini.');
      $data = isset($_POST['content'])?(string)$_POST['content']:'';
      if(strlen($data) > MAX_EDIT_BYTES) throw new Exception('Ukuran konten melebihi batas edit.');
      if(@file_put_contents($target,$data)===false) throw new Exception('Gagal menyimpan file.');
      flash_ok('Berhasil menyimpan perubahan.');
    } elseif($action==='rename'){
      $old = ensure_in_base(safe_realpath(isset($_POST['old'])?$_POST['old']:''));
      $new = ensure_in_base(safe_realpath(isset($_POST['new'])?$_POST['new']:''));
      if(!$old || !file_exists($old)) throw new Exception('Path asal tidak ditemukan.');
      if(file_exists($new)) throw new Exception('Target baru sudah ada.');
      if(!@rename($old,$new)) throw new Exception('Gagal rename.');
      flash_ok('Berhasil mengganti nama.');
    } elseif($action==='delete'){
      $target = ensure_in_base(safe_realpath(isset($_POST['target'])?$_POST['target']:''));
      if(!$target || !file_exists($target)) throw new Exception('Target tidak ditemukan.');
      if(!is_writable($target) && !is_writable(dirname($target))) throw new Exception('Tidak punya izin menghapus.');
      if(!rrmdir($target)) throw new Exception('Gagal menghapus (cek izin).');
      flash_ok('Berhasil menghapus.');
    } elseif($action==='zip'){
      ensure_zip_enabled();
      $items = isset($_POST['items'])?$_POST['items']:array();
      if(!is_array($items) || count($items)===0) throw new Exception('Tidak ada item dipilih.');
      $zipName = isset($_POST['zipname'])?trim((string)$_POST['zipname']):'arsip.zip';
      if($zipName==='') $zipName='arsip.zip';
      if(!str_ends_with(strtolower($zipName),'.zip')) $zipName.='.zip';
      $zipPath = ensure_in_base(safe_realpath($path.DIRECTORY_SEPARATOR.$zipName));
      if(file_exists($zipPath)) throw new Exception('Nama ZIP sudah ada.');
      $zip = new ZipArchive();
      if($zip->open($zipPath, ZipArchive::CREATE)!==true) throw new Exception('Gagal membuat file ZIP.');
      foreach($items as $i){ $ip = ensure_in_base(safe_realpath($i)); if(!$ip || !file_exists($ip)) continue; add_to_zip($zip,$ip,basename($ip)); }
      $zip->close();
      flash_ok('Berhasil membuat ZIP: '.$zipName);
    } elseif($action==='unzip'){
      ensure_zip_enabled();
      $zipFile = ensure_in_base(safe_realpath(isset($_POST['zipfile'])?$_POST['zipfile']:''));
      if(!$zipFile || !is_file($zipFile)) throw new Exception('File ZIP tidak valid.');
      $dest = ensure_in_base(safe_realpath(isset($_POST['dest'])?$_POST['dest']:$path));
      if(!$dest || !is_dir($dest)) throw new Exception('Folder tujuan tidak valid.');
      if(!is_writable($dest)) throw new Exception('Tidak punya izin tulis di folder tujuan.');
      $zip = new ZipArchive();
      if($zip->open($zipFile)!==true) throw new Exception('Gagal membuka ZIP.');
      if(!$zip->extractTo($dest)) { $zip->close(); throw new Exception('Gagal ekstrak ZIP.'); }
      $zip->close();
      flash_ok('Berhasil mengekstrak: '.basename($zipFile).' → '.$dest);
    } elseif($action==='upload'){
      if(!is_dir($path)) throw new Exception('Folder tujuan tidak valid.');
      if(!is_writable($path)) throw new Exception('Tidak punya izin tulis di folder ini.');
      if(empty($_FILES['files'])) throw new Exception('Tidak ada file diunggah.');
      $overwrite = !empty($_POST['overwrite']);
      $okCount=0; $fail=array(); $files=$_FILES['files']; $count=is_array($files['name'])?count($files['name']):0;
      for($i=0;$i<$count;$i++){
        $errNo=$files['error'][$i]; $origName=(string)$files['name'][$i];
        if($errNo!==UPLOAD_ERR_OK){ $fail[]=$origName.' (error='.$errNo.')'; continue; }
        $tmp=$files['tmp_name'][$i]; $base=basename($origName);
        if($base==='' || !is_uploaded_file($tmp)){ $fail[]=$origName.' (invalid tmp)'; continue; }
        $dest=$path.DIRECTORY_SEPARATOR.$base;
        if(file_exists($dest) && !$overwrite){
          $name=pathinfo($base,PATHINFO_FILENAME); $ext=pathinfo($base,PATHINFO_EXTENSION);
          $n=1; 
          while(true){ $cand=$name.' ('.$n.')'.($ext!==''?'.'.$ext:''); $dest=$path.DIRECTORY_SEPARATOR.$cand; if(!file_exists($dest) or $n>=10000) break; $n++; }
        }
        if(!@move_uploaded_file($tmp,$dest)){ $fail[]=$origName+' (gagal memindahkan)'; continue; }
        $okCount++;
      }
      if($okCount>0) flash_ok("Upload berhasil: {$okCount} file.");
      if(!empty($fail)) flash_err("Gagal: ".implode(', ', $fail));
    } elseif($action==='mkdir'){
      if(!is_dir($path)) throw new Exception('Folder induk tidak valid.');
      if(!is_writable($path)) throw new Exception('Tidak punya izin tulis di folder ini.');
      $name = isset($_POST['folder'])?trim((string)$_POST['folder']):'';
      if($name==='') throw new Exception('Nama folder tidak boleh kosong.');
      if(preg_match('~[\/\\\\]~',$name) || strpos($name,'..')!==false) throw new Exception('Nama folder tidak boleh mengandung /, \\ atau \"..\".');
      if(!preg_match('~^[\w\s\-\._\(\)\[\]\{\},@+#=]+$~u',$name)) throw new Exception('Nama folder mengandung karakter tidak valid.');
      $dest = ensure_in_base(safe_realpath($path.DIRECTORY_SEPARATOR.$name));
      if(file_exists($dest)) throw new Exception('Folder sudah ada.');
      $old = umask(0); $ok=@mkdir($dest,0775,true); umask($old);
      if(!$ok) throw new Exception('Gagal membuat folder (cek izin).');
      flash_ok('Berhasil membuat folder: '.$name);
    }
  } catch(Exception $e){ flash_err($e->getMessage()); }
  header('Location: ?p='.rawurlencode($path)); exit;
}
if(isset($_GET['a']) && $_GET['a']==='download'){
  $file = isset($_GET['file'])?(string)$_GET['file']:''; $fp=ensure_in_base(safe_realpath($file));
  if(!$fp || !is_file($fp) || !is_readable($fp)){ http_response_code(404); exit('File tidak ditemukan / tidak bisa dibaca.'); }
  while(ob_get_level()){ ob_end_clean(); }
  header('Content-Type: application/octet-stream');
  header('Content-Length: '.filesize($fp));
  header('Content-Disposition: attachment; filename="'.basename($fp).'"');
  header('X-Content-Type-Options: nosniff'); readfile($fp); exit;
}
$p = isset($_GET['p'])?(string)$_GET['p']:BASE_PATH;
$abs = ensure_in_base(safe_realpath($p)); if(!$abs)$abs=BASE_PATH;
include dirname(__FILE__).'/inc/header.php';
if(isset($_GET['a']) && $_GET['a']==='edit'){
  $file = isset($_GET['file'])?(string)$_GET['file']:''; $fp=ensure_in_base(safe_realpath($file));
  if($fp && is_file($fp) && is_readable($fp) && filesize($fp)<=MAX_EDIT_BYTES && is_text_file($fp)){
    $content=@file_get_contents($fp); if($content===false)$content=''; include dirname(__FILE__).'/inc/edit.php';
  } else { echo '<div class="alert err">File tidak bisa diedit.</div><p><a class="btn" href="?p='.h($abs).'">Kembali</a></p>'; }
} else {
  $canRead=is_readable($abs); $canList=$canRead&&is_dir($abs); $listing=$canList?list_dir($abs):array('dirs'=>array(),'files'=>array()); include dirname(__FILE__).'/inc/list.php';
}
include dirname(__FILE__).'/inc/footer.php';
